const API_URL = 'backend/api.php';

const apiFetch = async (action, options = {}) => {
    const url = `${API_URL}?action=${action}`;
    const response = await fetch(url, {
        ...options,
        headers: {
            'Content-Type': 'application/json',
            ...options.headers,
        },
    });

    if (!response.ok) {
        const error = await response.json();
        throw new Error(error.error || 'API request failed');
    }

    return response.json();
};

export const login = (username, password) =>
    apiFetch('login', { method: 'POST', body: JSON.stringify({ username, password }) });

export const getDashboard = () =>
    apiFetch('get_dashboard');

export const getInvoices = () =>
    apiFetch('get_invoices');

export const getCustomers = () =>
    apiFetch('get_customers');

export const getItems = () =>
    apiFetch('get_items');

export const saveInvoice = (invoiceData) =>
    apiFetch('save_invoice', { method: 'POST', body: JSON.stringify(invoiceData) });

export const saveCustomer = (customerData) =>
    apiFetch('save_customer', { method: 'POST', body: JSON.stringify(customerData) });

export const saveItem = (itemData) =>
    apiFetch('save_item', { method: 'POST', body: JSON.stringify(itemData) });
