import React, { useState } from 'react';
import { Fingerprint, Lock, User, ArrowRight } from 'lucide-react';
import { motion } from 'framer-motion';
import { login as apiLogin } from '../services/api';

const Login = ({ onLogin }) => {
    const [username, setUsername] = useState('');
    const [password, setPassword] = useState('');
    const [error, setError] = useState('');

    const handleSubmit = async (e) => {
        e.preventDefault();
        try {
            const data = await apiLogin(username, password);
            onLogin(data.user);
        } catch (err) {
            setError(err.message);
        }
    };

    const handleBiometric = async () => {
        // Placeholder for WebAuthn/Fingerprint
        alert('Biometric login would be triggered here using WebAuthn API.');
        onLogin({ username: 'AdminUser', role: 'Admin' });
    };

    return (
        <div style={{
            padding: '40px 24px',
            display: 'flex',
            flexDirection: 'column',
            justifyContent: 'center',
            height: '100vh',
            background: 'white'
        }}>
            <motion.div
                initial={{ opacity: 0, scale: 0.9 }}
                animate={{ opacity: 1, scale: 1 }}
                style={{ textAlign: 'center', marginBottom: '40px' }}
            >
                <div style={{
                    width: '80px',
                    height: '80px',
                    background: 'var(--primary)',
                    borderRadius: '20px',
                    display: 'flex',
                    alignItems: 'center',
                    justifyContent: 'center',
                    margin: '0 auto 16px',
                    boxShadow: '0 8px 16px rgba(0,119,197,0.3)'
                }}>
                    <Lock color="white" size={40} />
                </div>
                <h1 style={{ fontSize: '28px', color: 'var(--primary)' }}>QuickBooks</h1>
                <p style={{ color: 'var(--text-muted)' }}>Sign in to your account</p>
            </motion.div>

            <form onSubmit={handleSubmit} style={{ display: 'flex', flexDirection: 'column', gap: '16px' }}>
                <div style={{ position: 'relative' }}>
                    <User style={{ position: 'absolute', left: '12px', top: '50%', transform: 'translateY(-50%)' }} color="var(--text-muted)" size={20} />
                    <input
                        type="text"
                        placeholder="Username"
                        value={username}
                        onChange={(e) => setUsername(e.target.value)}
                        style={{ width: '100%', padding: '14px 14px 14px 44px', borderRadius: '12px', border: '1px solid var(--border-color)', fontSize: '16px', background: '#f8f9fa' }}
                    />
                </div>

                <div style={{ position: 'relative' }}>
                    <Lock style={{ position: 'absolute', left: '12px', top: '50%', transform: 'translateY(-50%)' }} color="var(--text-muted)" size={20} />
                    <input
                        type="password"
                        placeholder="Password"
                        value={password}
                        onChange={(e) => setPassword(e.target.value)}
                        style={{ width: '100%', padding: '14px 14px 14px 44px', borderRadius: '12px', border: '1px solid var(--border-color)', fontSize: '16px', background: '#f8f9fa' }}
                    />
                </div>

                {error && <p style={{ color: 'var(--error)', fontSize: '14px', textAlign: 'center' }}>{error}</p>}

                <button type="submit" className="btn-primary" style={{ marginTop: '8px', display: 'flex', alignItems: 'center', justifyContent: 'center', gap: '8px' }}>
                    Sign In <ArrowRight size={20} />
                </button>
            </form>

            <div style={{ margin: '32px 0', borderTop: '1px solid var(--border-color)', position: 'relative' }}>
                <span style={{ position: 'absolute', left: '50%', top: '50%', transform: 'translate( -50%, -50%)', background: 'white', padding: '0 12px', color: 'var(--text-muted)', fontSize: '14px' }}>OR</span>
            </div>

            <button
                onClick={handleBiometric}
                style={{
                    background: 'transparent',
                    border: '1px solid var(--primary)',
                    color: 'var(--primary)',
                    display: 'flex',
                    alignItems: 'center',
                    justifyContent: 'center',
                    gap: '12px',
                    padding: '12px'
                }}
            >
                <Fingerprint size={24} /> Use Fingerprint
            </button>

            <p style={{ textAlign: 'center', marginTop: 'auto', fontSize: '12px', color: 'var(--text-muted)' }}>
                Private & Secure • Multi-user Access
            </p>
        </div>
    );
};

export default Login;
