---
description: How to deploy the QuickBooks Clone to a production web server (e.g. Truehost, Bluehost)
---
# Deployment Workflow

Follow these steps to take your app live on a standard PHP/MySQL web server.

### 1. Database Setup
1. Log in to your hosting control panel (e.g., cPanel).
2. Create a new **MySQL Database** and a **Database User** with full privileges.
3. Open **phpMyAdmin**, select your new database, and use the **Import** tab to upload the `backend/schema.sql` file.

### 2. Configure Backend
1. Open `backend/config.php`.
2. Update the `$host`, `$db`, `$user`, and `$pass` variables with your live database credentials.
3. Ensure the `Access-Control-Allow-Origin` in `config.php` matches your domain name (or keep `*` for testing).

### 3. Upload Files
1. Use an FTP client (like FileZilla) or the File Manager in your cPanel.
2. Upload the **contents** of the `dist/` folder directly to your web root (usually `public_html`).
3. Upload the entire `backend/` folder to your web root so it sits alongside `index.html`.

### 4. SPA Routing (Optional but Recommended)
If you find that refreshing a page (like `/invoices`) gives a 404 error, create a file named `.htaccess` in your `public_html` folder with this content:
```apache
<IfModule mod_rewrite.c>
  RewriteEngine On
  RewriteBase /
  RewriteRule ^index\.html$ - [L]
  RewriteCond %{REQUEST_FILENAME} !-f
  RewriteCond %{REQUEST_FILENAME} !-d
  RewriteCond %{REQUEST_FILENAME} !-y
  RewriteRule . /index.html [L]
</IfModule>
```

### 5. Verify
1. Visit your domain in a browser.
2. Log in and try creating an invoice to verify the backend connection.
3. On your mobile phone, use "Add to Home Screen" to install it as a PWA.
